/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.common.shop.type;

import de.cadentem.quality_food.util.OverlayUtils;
import de.cadentem.quality_food.util.QualityUtils;
import dev.architectury.platform.Platform;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.sixik.sdmshoprework.SDMShopR;
import net.sixik.sdmshoprework.SDMShopRework;
import net.sixik.sdmshoprework.api.IConstructor;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntry;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntryType;
import net.sixik.sdmshoprework.common.utils.NBTUtils;
import net.sixik.sdmshoprework.common.utils.SDMItemHelper;
import net.sixik.sdmshoprework.common.utils.item.ItemHandlerHelper;

public class ShopItemEntryType
extends AbstractShopEntryType {
    public ItemStack itemStack;

    public ShopItemEntryType(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    @Override
    public void getConfig(ConfigGroup group) {
        group.addItemStack("item", this.itemStack, v -> {
            this.itemStack = v;
        }, ItemStack.f_41583_, true, true);
    }

    @Override
    public boolean isSearch(String search) {
        return this.itemStack.m_41611_().getString().contains(search) || Registry.f_122827_.m_7981_((Object)this.itemStack.m_41720_()).toString().contains(search);
    }

    @Override
    public AbstractShopEntryType copy() {
        return new ShopItemEntryType(this.itemStack);
    }

    @Override
    public Component getTranslatableForCreativeMenu() {
        return Component.m_237115_((String)"sdm.shop.entry.add.context.item");
    }

    @Override
    public List<Component> getDescriptionForContextMenu() {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Component.m_237115_((String)"sdmr.shop.entry.creator.type.itemType.description"));
        return list;
    }

    @Override
    public void sendNotifiedMessage(Player player) {
        if (this.shopEntry.isSell) {
            MutableComponent text = Component.m_237110_((String)"sdm.shop.entry.sell.info.item", (Object[])new Object[]{this.itemStack.m_41611_().getString(), this.shopEntry.entryCount, SDMShopRework.moneyString(SDMShopR.getMoney(player))}).m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY);
            player.m_5661_((Component)text, false);
        } else {
            MutableComponent text = Component.m_237110_((String)"sdm.shop.entry.buy.info.item", (Object[])new Object[]{this.itemStack.m_41611_().getString(), this.shopEntry.entryCount, SDMShopRework.moneyString(SDMShopR.getMoney(player))}).m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY);
            player.m_5661_((Component)text, false);
        }
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        NBTUtils.putItemStack(nbt, "itemStack", this.itemStack);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        this.itemStack = NBTUtils.getItemStack(nbt, "itemStack");
    }

    @Override
    public String getId() {
        return "shopItemEntryType";
    }

    @Override
    public Icon getIcon() {
        ItemStack d1 = this.itemStack.m_41777_();
        d1.m_41764_(this.shopEntry.entryCount);
        if (Platform.isModLoaded((String)"quality_food") && QualityUtils.hasQuality((ItemStack)d1)) {
            d1 = OverlayUtils.getOverlay((ItemStack)d1);
            d1.m_41764_(this.shopEntry.entryCount);
        }
        return ItemIcon.getItemIcon((ItemStack)d1);
    }

    @Override
    public void buy(Player player, int countBuy, AbstractShopEntry entry) {
        long playerMoney = SDMShopR.getMoney(player);
        long needMoney = entry.entryPrice * (long)countBuy;
        for (int i = 0; i < countBuy; ++i) {
            ItemStack d1 = this.itemStack.m_41777_();
            d1.m_41764_(entry.entryCount);
            ItemHandlerHelper.giveItemToPlayer(player, d1);
        }
        SDMShopR.setMoney(player, playerMoney - needMoney);
    }

    @Override
    public void sell(Player player, int countSell, AbstractShopEntry entry) {
        int amount;
        ItemStack stack = this.itemStack.m_41777_();
        ArrayList stackList = new ArrayList();
        int amountItems = SDMItemHelper.countItems(player, stack);
        int n = amount = amountItems >= entry.entryCount * countSell ? entry.entryCount * countSell : 0;
        if (amountItems == 0 || amount == 0) {
            return;
        }
        if (amount <= 0) {
            return;
        }
        if (SDMItemHelper.sellItem(player, amount, stack)) {
            SDMShopR.addMoney(player, entry.entryPrice * (long)countSell);
        }
    }

    @Override
    public boolean canExecute(Player player, boolean isSell, int countSell, AbstractShopEntry entry) {
        long needMoney;
        if (isSell) {
            int countItems = 0;
            Inventory inventory = player.m_150109_();
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                if (!inventory.m_8020_(i).equals(this.itemStack)) continue;
                countItems += inventory.m_8020_(i).m_41613_();
            }
            return countItems >= entry.entryCount * countSell;
        }
        long playerMoney = SDMShopR.getMoney(player);
        return playerMoney >= (needMoney = entry.entryPrice * (long)countSell) && playerMoney - needMoney >= 0L;
    }

    @Override
    public int howMany(Player player, boolean isSell, AbstractShopEntry entry) {
        if (isSell) {
            int countItems = 0;
            Inventory inventory = player.m_150109_();
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                if (!inventory.m_8020_(i).m_150930_(this.itemStack.m_41720_()) || !Objects.equals(inventory.m_8020_(i).m_41783_(), this.itemStack.m_41783_())) continue;
                countItems += inventory.m_8020_(i).m_41613_();
            }
            return countItems / entry.entryCount;
        }
        long playerMoney = SDMShopR.getMoney(player);
        if (entry.entryPrice == 0L) {
            return 127;
        }
        return (int)(playerMoney / entry.entryPrice);
    }

    public static class Constructor
    implements IConstructor<AbstractShopEntryType> {
        @Override
        public ShopItemEntryType createDefaultInstance() {
            return new ShopItemEntryType(ItemStack.f_41583_);
        }
    }
}

